-- ************************************************************************
-- Project: Modding Tools & Utilities
-- ------------------------------------------------------------------------
-- Purpose: Utilitiy methods and members for modelling W3D Model
-- Module : W3DMeshWork.ms
-- Author : Level_3D_Vision (c) 2008-2011
-- System : MaxScript utility for GMAX
-- ------------------------------------------------------------------------
-- History: 18.10.07 -- created by Jerry Brutzki
--          14.07.11 -- changed by Jerry Brutzki
-- ************************************************************************
---------------------------------------------------------------------------
------------------------------------------------------------ scriptName ---
macroscript W3DModelHide
    category: "LOTR ModelW3D Utility"
    buttontext: "ModelW3D Utility"
    tooltip: "Hide selected 3D Objects"
    icon:#("Standard_Modifiers",19)
(
    max hide selection
)

---------------------------------------------------------------------------
------------------------------------------------------------ scriptName ---
macroscript W3DModelUnHide
    category: "LOTR ModelW3D Utility"
    buttontext: "ModelW3D Utility"
    tooltip: "Unhide selected 3D Objects"
    icon:#("Standard_Modifiers",21)
(
    max unhide by name
)

---------------------------------------------------------------------------
------------------------------------------------------------ scriptName ---
macroscript W3DModelCopy
    category: "LOTR ModelW3D Utility"
    buttontext: "ModelW3D Utility"
    tooltip: "Copy selected 3D Object"
    icon:#("Standard_Modifiers",28)
(
    CopySelectedObject()
)

---------------------------------------------------------------------------
function CopySelectedObject =
---------------------------------------------------------------------------
(
    local userOBJ = #()
    userOBJ = getCurrentSelection()

    if (userOBJ.count == 0) then
    (
       MessageBox ("Please, select your W3D model first before starting !")
       return false
    )

    local ListVerts = #()
    local ListFaces = #()
    local TempVal = 0
    local CopyOBJ = 0
    local Vtx = 0

    if (userOBJ.count == 1) then
    (
       if ((classOf userOBJ[1]) == Editable_Mesh) then
       (
          for Vtx = 1 to userOBJ[1].numverts do
          (
             TempVal = getvert userOBJ[1] Vtx
             append ListVerts TempVal
          )
          for Vtx = 1 to userOBJ[1].numfaces do
          (
             TempVal = getface userOBJ[1] Vtx
             append ListFaces TempVal
          )

          CopyOBJ = mesh vertices:ListVerts faces:ListFaces
          -- Preserve Smoothing Groups & Mat IDs
          for Vtx =1 to userOBJ[1].numfaces do
          (
             SetFaceSmoothGroup CopyOBJ Vtx (GetFaceSmoothGroup userOBJ[1] Vtx)
             SetFaceMatID CopyOBJ Vtx (GetFaceMatID userOBJ[1] Vtx)
          )

          -- Preserve Object Colour
          CopyOBJ.wirecolor = userOBJ[1].wirecolor
          CopyOBJ.pivot= userOBJ[1].pivot
          CopyOBJ.name = userOBJ[1].name + "_001"
          CopyOBJ.pos  = [50,0,0]
          update CopyOBJ
       )
    )

    clearSelection()
    return true
)

---------------------------------------------------------------------------
------------------------------------------------------------ scriptName ---
macroscript W3DModelTurn
    category: "LOTR ModelW3D Utility"
    buttontext: "ModelW3D Utility"
    tooltip: "Turn selected 3D Object"
    icon:#("Maintoolbar",23)
(
    TurnSelectedObject()
)

---------------------------------------------------------------------------
function TurnSelectedObject =
---------------------------------------------------------------------------
(
    local userOBJ = #()
    userOBJ = getCurrentSelection()

    if (userOBJ.count == 0) then
    (
       MessageBox ("Please, select your W3D model first before starting !")
       return false
    )

    if (userOBJ.count == 1) then
    (
       if ((classOf userOBJ[1]) == Editable_Mesh) then
       (
         max rotate
         rotate userOBJ[1] (angleaxis 88.5 [0,0,1])
         update userOBJ[1]
         max tool maximize
       )
    )
)

---------------------------------------------------------------------------
------------------------------------------------------------ scriptName ---
macroscript W3DModelMode
    category: "LOTR ModelW3D Utility"
    buttontext: "ModelW3D Utility"
    tooltip: "Open selected 3D Object"
    icon:#("Standard_Modifiers",10)
(
    OpenSelectedObject()
)

---------------------------------------------------------------------------
function OpenSelectedObject =
---------------------------------------------------------------------------
(
    local tickVertices = #()
    local userOBJ = #()
    userOBJ = getCurrentSelection()

    if (userOBJ.count == 0) then
    (
       MessageBox ("Please, select your W3D model first before starting !")
       return false
    )

    if (userOBJ.count == 1) then
    (
       if ((classOf userOBJ[1]) == Editable_Mesh) then
       (
         max modify mode; subObjectLevel = 1
         select userOBJ[1].verts

         tickVertices = userOBJ[1].selectedVerts
         select tickVertices
         modPanel.setCurrentObject userOBJ[1]
       )
    )
)

---------------------------------------------------------------------------
------------------------------------------------------------ scriptName ---
macroscript W3DMeshWWSkin
    category: "LOTR ModelW3D Utility"
    buttontext: "Bind BFME model"
    tooltip: "Bind model to WWSkin"
    icon:#("Maintoolbar",9)
(
    userMesh = getCurrentSelection()
    if ((classOf userMesh[1]) == Editable_Mesh) then
    (
       local wwSkinObject =  WWSkinSpaceWarp() [0,0,0]
       wwSkinObject.pos = [(userMesh[1].pos.x + 10),(userMesh[1].pos.y + 10),0]
       Scale  wwSkinObject [4,4,4];     select wwSkinObject

       max bind space warp mode
       bindSpaceWarp userMesh[1] wwSkinObject
       format "Mesh to WWSkin:  % --->> %\n" userMesh[1].name wwSkinObject.name
       max select
    )

    userMesh = #()
    clearSelection()
)

-- ************************************************************************
-- Module:  W3DMeshWork.ms -- End of File
-- ************************************************************************

