-- ************************************************************************
-- Project: Modding Tools & Utilities
-- ------------------------------------------------------------------------
-- Purpose: Basic methods and members for setting viewports in GMAX
-- Module : W3DViewPort.ms
-- Author : Level_3D_Vision (c) 2008-2011
-- System : MaxScript utitility for GMAX
-- ------------------------------------------------------------------------
-- History: 12.02.07 -- created by Jerry Brutzki
--          14.97.11 -- changed by Jerry Brutzki
-- ************************************************************************
---------------------------------------------------------------------------
function Setup1WindowViewport =
---------------------------------------------------------------------------
(
    viewport.setLayout #layout_1
    viewport.activeViewport = 1
    viewport.setType #view_persp_user
    max wire smooth
)

---------------------------------------------------------------------------
------------------------------------------------------------ scriptName ---
macroscript SetViewWith1Window
    category: "LOTR ModelW3D Utility"
    buttontext: "W3D ViewPort(1)"
    tooltip: "Viewport with 1 windows"
    icon:#("VPort_layout",1)
(
    Setup1WindowViewport()
)


---------------------------------------------------------------------------
function Setup2WindowViewport =
---------------------------------------------------------------------------
(
    viewport.setLayout #layout_2v
    viewport.activeViewport = 1
    viewport.setType #view_right
    viewport.activeViewport = 2
    viewport.setType #view_front
)

---------------------------------------------------------------------------
------------------------------------------------------------ scriptName ---
macroscript SetViewWith2Window
    category: "LOTR ModelW3D Utility"
    buttontext: "W3D ViewPort(2)"
    tooltip: "Viewport with 2 windows"
    icon:#("VPort_layout",2)
(
    Setup2WindowViewport()
)

---------------------------------------------------------------------------
function Setup3WindowViewport =
---------------------------------------------------------------------------
(
    viewport.setLayout #layout_3vr
    viewport.activeViewport = 1
    viewport.setType #view_top
    viewport.activeViewport = 2
    viewport.setType #view_back
    viewport.activeViewport = 3
    viewport.setType #view_right
)

---------------------------------------------------------------------------
------------------------------------------------------------ scriptName ---
macroscript SetViewWith3Window
    category: "LOTR ModelW3D Utility"
    buttontext: "W3D ViewPort(3)"
    tooltip: "Viewport with 3 windows"
    icon:#("VPort_layout",6)
(
    Setup3WindowViewport()
)

---------------------------------------------------------------------------
function Setup4WindowViewport =
---------------------------------------------------------------------------
(
    viewport.ResetAllViews() 
)

---------------------------------------------------------------------------
------------------------------------------------------------ scriptName ---
macroscript SetViewWith4Window
    category: "LOTR ModelW3D Utility"
    buttontext: "W3D ViewPort(4)"
    tooltip: "Viewport with 4 windows"
    icon:#("VPort_layout",14)
(
    Setup4WindowViewport()
)

-- ************************************************************************
-- Module:  W3DViewPort.ms -- End of File
-- ************************************************************************

